
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Feb 20 12:11:20 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_Ext_ATP_TST_DH_MAIN.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */

/***** Include Files ******/
#include "CRYS.h"

#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_Ext_ATP_DH_Acceptance.h"

#include <stdio.h>

/******** Defines *********/
/******** Enums *********/
/******** Typedefs ********/
/******** Global Data *******/
/***** Private function prototype *****/
CRYSError_t CRYS_ExtApp_ATP_DH_Acceptance_ALL_TESTS(void);


/******** Public Functions **********/
void CRYS_ExtApp_ATP_DH_main(void)
{
  DxUint8_t  Var;
 
  do
   {  
	   do
	   {
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n\n--[ Ext SEP application DH Acceptance tests ]-------------------"));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [1] - PKCS#3 key agreament               "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [2] - ANSI 9.42 key agreament            "));	           
			   
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [T] - ALL DH Acceptance tests            "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [Z] - End of tests return to prev menu   "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n---------------------------------------\n\n"));
	           scanf("\n%c",&Var);
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Test = %c\n",Var));
	           if (Var<='Z')
	                    break;
	           else
	           {
	                 ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
	           }

	    }while(1);

     
	    switch(Var)
	    {
		  	case '1': 
				    CRYS_Ext_ATP_DH_Acceptance_PKCS3();
				    break;
		  	case '2': 				    
				    CRYS_Ext_ATP_DH_Acceptance_ANSI942();
				    break;				    
			
		  	case 'T': 
		  			CRYS_ExtApp_ATP_DH_Acceptance_ALL_TESTS();
				    break;	    			    
	       	case 'Z':
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n End of DH tests \n"));
	                break ;
	              
	       	default:
	              ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n* Error in test selection [%c]\n",Var));
	    }
	       if(Var =='Z')
	       break;       
     }while (1);
}


/******** Private Functions **********/
/***************************
 * Function Name:                                                           
 * 	CRYS_ExtApp_ATP_DH_Acceptance_ALL_TESTS 		
 * 
 * Inputs:
 * 	none 
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * This function runs all of the DH Acceptance tests 
 *
 **************************/
CRYSError_t CRYS_ExtApp_ATP_DH_Acceptance_ALL_TESTS(void)
{
    CRYSError_t TST_DH_ATP_Error = TESTPASS;

    TST_ATP_Error = CRYS_Ext_ATP_DH_Acceptance_PKCS3();
    TST_DH_ATP_Error = TST_DH_ATP_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_DH_ATP_Error != TESTPASS)
			    return 	TST_DH_ATP_Error;
    #endif

    TST_ATP_Error = CRYS_Ext_ATP_DH_Acceptance_ANSI942();
    TST_DH_ATP_Error = TST_DH_ATP_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_DH_ATP_Error != TESTPASS)
			    return 	TST_DH_ATP_Error;
    #endif

	TST_DH_ATP_Error = TST_DH_ATP_Error+TST_ATP_Error;

#if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	if (TST_DH_ATP_Error != TESTPASS)
		return 	TST_DH_ATP_Error;
#endif

		
	/*Check if all tests pass*/
	if (TST_DH_ATP_Error != TESTPASS)
	{
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE DH TESTS FAILED !!!!!!!!!!!!!!!!!!!!!\n"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
	}
	else
	{
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n \n**********************\n"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*** ALL OF THE DH Acceptance TESTS PASS    :-)         ***\n"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));								
	}
    return TST_DH_ATP_Error;
}



